import matplotlib.pyplot as pyplot
import numpy
from matplotlib.colors import LinearSegmentedColormap,ListedColormap
from matplotlib import rcParams, lines
from matplotlib.collections import LineCollection
from matplotlib.colors import ListedColormap, BoundaryNorm,LogNorm
from matplotlib.ticker import MultipleLocator, ScalarFormatter,FuncFormatter,FormatStrFormatter
from scipy.optimize import fsolve as fsolve
import scipy.optimize as optimise
from matplotlib import gridspec
import scipy.interpolate as interp
from matplotlib.patches import ConnectionPatch,FancyBboxPatch,Rectangle
import os
from jqc import jqc_plot

Wavelength=1064
alpha0_1550 = 507
alpha90_1550 = 602

Trans = 0.944851
w = 172.6e-6

jqc_plot.plot_style("normal")
directory = os.path.dirname(os.path.abspath(__file__))
root= os.path.dirname(os.path.dirname(directory))

Data_Exp = numpy.genfromtxt(directory+"\\MF5_350G.csv",delimiter=',')

Data_Theory = numpy.genfromtxt(root+"\\Beta = 63\\lines.dat")

fig = pyplot.figure()
ax = fig.add_subplot(111)

Int= 1e-7*Data_Exp[:,0]*Trans*1.04*2/(numpy.pi*w**2)
ax.errorbar(Int,1e3*(Data_Exp[:,1]-Data_Exp[0,1]),1e3*Data_Exp[:,2],fmt='o',color='k')


Intensities = numpy.linspace(0,2.5,150)
ax.plot(Data_Theory[:,0]*1e-3,Data_Theory[:,1]-980.231e3)

ax.plot([1.11,1.11],[-45,15],ls='--',color='k')
ax.set_xlim(0,2.5)
ax.set_ylim(-15,5)
ax.set_xlabel("Intensity (kW/cm$^2$)")
ax.set_ylabel("Frequency Shift (kHz)")
pyplot.tight_layout()

pyplot.savefig(directory+"\\Intensity_63deg_noline.pdf")
pyplot.savefig(directory+"\\Intensity_63deg_noline.png")
pyplot.show()
